----------------------------------------------------------------------------------
-- Company: TalTech
-- Engineer: Artjom Jukov
-- 
-- Create Date: 05/11/2019 10:52:37 PM
-- Design Name: 
-- Module Name: algorithm - Behavioral
-- Project Name: Bachelor thesis
-- Target Devices: Basys 3
-- Tool Versions: Vivado 2018.3
-- Description:
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity algorithm is
  port ( clk, rst: in std_logic;
	  rdy: out std_logic := '0';
         a, b: in unsigned(7 downto 0);
        c, c2: out unsigned(15 downto 0);
	   sel: in std_logic_vector(1 downto 0);
	   dbg: out unsigned(15 downto 0)
);
end entity algorithm;

--Synthesiable algorithm of simulatable algorithm 
architecture bhv of algorithm is
    type state_type is (S_wait, S_start, S_ready);
    signal state, next_state: state_type;
	signal ar, br, next_ar, next_br: unsigned(7 downto 0);
	signal cr, next_cr: unsigned(15 downto 0);
	signal next_counter, counter: unsigned(7 downto 0);
	signal enabled_c, set_rdy, multiply: std_logic;
	constant z8: unsigned (0 to 7) := (others => '0');
begin
    -- Control machine. In that process if condition is true change the state.
   process (state, rst, a, b, ar, br, cr, counter)
    variable c_bf: unsigned(15 downto 0);
   begin
   --Arguments holding default values
    enabled_c <= '0';
    set_rdy <= '0';
    next_ar <= ar;
    next_br <= br;
    next_cr <= cr;
    next_state <= state;
    next_counter <= counter;
    case  state  is
    
    -- Wait for the new input data, if reset pushed going to start state
    when S_wait =>
      next_ar <= a; next_br <= b; next_cr <= (others => '0'); next_counter <= (others => '0');
      if  rst='1'  then
        next_state <= S_start;
      end if;
      
    -- Loop: start
    when S_start =>
      -- Until coutner don't equal 8, going back to start state
      -- when counter equals 8, going to ready state
      if counter < 8 then
          next_counter <= counter + 1;
          if  br(0) = '1'  then
              c_bf := cr + (ar & z8);
          else
              c_bf := cr;
          end if;
          next_cr <= '0' & c_bf(15 downto 1);
          next_br <= '0' & br(7 downto 1);
          next_state <= S_start; 
      else                  
        next_state <= S_ready;    
      end if;
    -- Ready state
    -- Signals that algorithm is finished job
    when S_ready =>
      enabled_c <= '1';    set_rdy <= '1';    next_state <= S_wait;
    end case;
  end process;

  -- Registers
  -- Assign to main registers 
  -- values from intermediate registers when clk = '1'
  process(clk)
  begin
    if rising_edge(clk) then
        state <= next_state;
        counter <= next_counter;
        rdy <= set_rdy;
        ar <= next_ar;
        br <= next_br;
        cr <= next_cr;
        if enabled_c = '1' then
            c <= cr;
        end if;
    end if;
  end process;
  
  -- Multiplexor
  --  The process where is decided 
  --  which register will be shown on the display
  process(sel, ar, br, cr, counter)
  begin 
	case sel is 
		when "00" => dbg <= z8 & counter;
		when "01" => dbg <= z8 & ar;
		when "10" => dbg <= z8 & br;
		when "11" => dbg <= cr;
		when others => dbg <= (others => '0');
	end case;
   end process;

end architecture bhv;

