----------------------------------------------------------------------------------
-- Company: Nandland
-- Engineer: 
-- 
-- Create Date: 05/05/2019 09:00:16 PM
-- Design Name: 
-- Module Name: debounce_button - RTL
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: Module help got from:
-- https://www.nandland.com/goboard/debounce-switch-project.html
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

entity debounce_button is
  port (
    clk    : in  std_logic;
    in_button_signal : in  std_logic;
    out_debounced_signal : out std_logic
    );
end entity debounce_button;
 
 --Architecture of debouncer
architecture RTL of debounce_button is

  constant c_DEBOUNCE_LIMIT : integer := 50000;
  signal count_register : integer range 0 to c_DEBOUNCE_LIMIT := 0;
  signal state_register : std_logic := '0';
 
begin
  process(clk)
  begin
    if rising_edge(clk) then
 
      -- Switch input is different than internal switch value, so an input is
      -- changing.  Increase counter until it is stable for c_DEBOUNCE_LIMIT.
      if (in_button_signal /= state_register and count_register < c_DEBOUNCE_LIMIT) then
        count_register <= count_register + 1;
 
      -- End of counter reached, switch is stable, register it, reset counter
      elsif count_register = c_DEBOUNCE_LIMIT then
        state_register <= in_button_signal;
        count_register <= 0;
 
      -- Switches are the same state, reset the counter
      else
        count_register <= 0;
 
      end if;
    end if;
  end process p_Debounce;
 
  -- Assign internal register to output (debounced!)
  out_debounced_signal <= state_register;
 
end architecture RTL;