------------------------------------------------------------------------------------
---- Company: fpga4student
---- Engineer: 
---- 
---- Create Date: 04/21/2019 06:30:18 PM
---- Design Name: 
---- Module Name: seven_segment_display - Behavioral
---- Project Name: 
---- Target Devices: 
---- Tool Versions: 
---- Description:Help got from tutorial:
---- https://www.fpga4student.com/2017/09/vhdl-code-for-seven-segment-display.html
---- 
---- Dependencies: 
---- 
---- Revision:
---- Revision 0.01 - File Created
---- Additional Comments:
---- 
------------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

---- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;


entity seven_segment_display is
   Port ( clk : in STD_LOGIC;
          displayed_number : in STD_LOGIC_VECTOR(15 downto 0) := "0000000000000000";
          an : out STD_LOGIC_VECTOR(3 downto 0);
          seg : out STD_LOGIC_VECTOR(6 downto 0));
end seven_segment_display;

-- Seven segment display architecture
architecture Behavioral of seven_segment_display is
   signal refresh_counter : STD_LOGIC_VECTOR(19 downto 0);
   signal digit : STD_LOGIC_VECTOR(3 downto 0) := "0000";
   signal led_activation_order : STD_LOGIC_VECTOR(1 downto 0);
begin
    -- Decoder for segment, in this process assigne bits to the segments  
   process(digit)
   begin
       case digit is
       when "0000" => seg <= "1000000"; -- "0"     
       when "0001" => seg <= "1111001"; -- "1" 
       when "0010" => seg <= "0100100"; -- "2" 
       when "0011" => seg <= "0110000"; -- "3" 
       when "0100" => seg <= "0011001"; -- "4" 
       when "0101" => seg <= "0010010"; -- "5" 
       when "0110" => seg <= "0000010"; -- "6" 
       when "0111" => seg <= "1111000"; -- "7" 
       when "1000" => seg <= "0000000"; -- "8"     
       when "1001" => seg <= "0010000"; -- "9" 
       when "1010" => seg <= "0100000"; -- a
       when "1011" => seg <= "0000011"; -- b
       when "1100" => seg <= "1000110"; -- C
       when "1101" => seg <= "0100001"; -- d
       when "1110" => seg <= "0000110"; -- E
       when "1111" => seg <= "0001110"; -- F
       end case;
   end process;
    
   --Processe where counter +1 when clk = '1'
   process(clk)
   begin 
       if(rising_edge(clk)) then
           refresh_counter <= std_logic_vector(unsigned(refresh_counter) + 1);
       end if;
   end process;
   
   --Assigne counter to the buffer register
   led_activation_order<= refresh_counter(19 downto 18);
    
   -- Process which choose between digits to display
   process(led_activation_order)
   begin
       case led_activation_order is
       when "00" =>
           an <= "0111"; 
           -- activate LED1 and Deactivate LED2, LED3, LED4
           digit <= displayed_number(15 downto 12);
           -- the first hex digit of the 16-bit number
       when "01" =>
           an <= "1011"; 
           -- activate LED2 and Deactivate LED1, LED3, LED4
           digit <= displayed_number(11 downto 8);
           -- the second hex digit of the 16-bit number
       when "10" =>
           an <= "1101"; 
           -- activate LED3 and Deactivate LED2, LED1, LED4
           digit <= displayed_number(7 downto 4);
           -- the third hex digit of the 16-bit number
       when "11" =>
           an <= "1110"; 
           -- activate LED4 and Deactivate LED2, LED3, LED1
           digit <= displayed_number(3 downto 0);
           -- the fourth hex digit of the 16-bit number    
       end case;
   end process;

end Behavioral;