%data processing of AT command results of Quectel

clear
clc


original_files=dir("datafolder\*.txt"); % select QCOM log files saved as .txt

% collect desired values
%AT command
%AT+QENG="servingcell"
%Response
%In SA mode:
%+QENG: "servingcell",<state>,"NR5G-SA",<duplex_mode>,<MCC>,<MNC>,<cellID>,<PCID>,<TAC>,<ARFCN>,<band>,<NR_DL_bandwidth>,<RSRP>,<RSRQ>,<SINR>,<scs>,<srxlev>
%Example
%[2024-10-18_14:30:53:921]AT+QENG="servingcell"
%[2024-10-18_14:30:53:921]+QENG: "servingcell","NOCONN","NR5G-SA","TDD",248,27,0000103FC,120,1388,634080,77,3,-93,-10,16,1,36

% !!add this line for each QCOM data file
% Var1,Var2,Var3,Var4,mcc,mnc,cellid,Var8,Var9,Var10,Var11,Var12,rsrp,rsrq,sinr,Var16,Var17

%% read data from files

for k=1:length(original_files)
    filename=sprintf('%s\\%s',original_files(k).folder,original_files(k).name);
    DS=readtable(filename,Filetype="text",Delimiter="comma",ReadVariableNames=1,EmptyLineRule="skip",VariableNamingRule="preserve");

    %remove lines with command
    DS2=rmmissing(DS,'DataVariables','Var2');
    [rows,~]=size(DS2);


    %replace with correct variables from DS2
    RSRP(:,k)=DS2.rsrp;
    RSRQ(:,k)=DS2.rsrq;
    RSRQ(:,k)=DS2.sinr;
    %add any other variable to identify measurement point
end

%% Calculations
% example remove missing values
RSRPclean=rmmissing(RSRP,1);
[rows,~]=size(RSRPclean);

LatMatrix=59.39+(0.01*rand(rows,1));%replace with your X coordinates
LonMatrix=24.66+(0.01*rand(rows,1));%replace with your Y coordinates


%calculate color for your RSRP marker
%

% %https://se.mathworks.com/matlabcentral/answers/897552-get-colormap-values-corresponding-to-array-values
% You need to specify the number of colors to represent these cvars
n = max(RSRPclean(:,1))-min(RSRPclean(:,1));
cmap = jet(n);

% cvars has a different range from cmap range (1:512), so you have to map
% it. (similar to imagesc)
cvars_map = round((RSRPclean-min(RSRPclean))/(max(RSRPclean)-min(RSRPclean))*(n-1)+ 1,0);

for i=1:rows
C(i,:)=cmap(cvars_map(i), :);
end

%% plot graphs

figure(1) %if GPS coordinates exist
clf

geoscatter(LatMatrix,LonMatrix,[],C,"filled"); 

colormap("jet")
cb=colorbar;
clim([min(RSRPclean(:,1)),max(RSRPclean(:,1))]) %set the scale on colorbar according to RSRP values



figure(2) % if manual locations on PNG background
clf

%background image
%scatter(x,y,sz,c) sz-size, c-color
scatter(LonMatrix,LatMatrix,100,C,"filled"); 
%axis tight; 
colormap("jet")
cb=colorbar;
clim([min(RSRPclean(:,1)),max(RSRPclean(:,1))]) %set the scale on colorbar according to RSRP values
hold on

% https://se.mathworks.com/matlabcentral/answers/358131-png-as-figure-background
I = imread('datafolder/room209.png'); 
h = image(xlim,flip(ylim),I); 
uistack(h,'bottom')
hold on


  